{******************************************************************************
 *  patchnos.dpr - nucleOS kernel.sw patch
 *
 *
 *  Copyright (c) 2004 nucleOS Group [http://nucle-os.sourceforge.net/]
 *                                   [http://www.sf.net/projects/nucle-os]
 *                                   [http://www.saint-soft.de/nucleos/board/]
 *
 *  version 0.1 - 02/03/2004 - first release
 *
 *  written by
 *    Michael Gerh"auser (saberrider) [saberrider@users.sourceforge.net]
 *
 *  This file does
 *   - search for string "    mov	byte [0],1" in file and delete it if found
 *
 *  To be implemented
 *   - %
 *
 * This program is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software Foundation
 * (version 2, June 1991)
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program; if not, write to:
 * Free Software Foundation, Inc.
 * 59 Temple Place, Suite 330
 * Boston, MA 02111-1307 USA
 *
 ******************************************************************************
 *
 *   This program is used to delete a line in asm source generated by FPC.
 *   This line of code tries to acces one byte of memory located at 0x0, which
 *   is not available in nucleOS virtual memory.
 *
 ******************************************************************************}

program patchnos;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  Classes;

const
    copyright1 = 'Patch nucleOS kernel.sw v0.1';
    copyright2 = '(c) 2004 saberrider, nucleOS Group [saberrider@users.sourceforge.net]';
    gpl1 = 'This program is free software; you can redistribute it and/or modify it under';
    gpl2 = 'the terms of the GNU General Public License as published by the Free Software';
    gpl3 = 'Foundation (version 2, June 1991)';

    usage = 'Usage: pastchnos file'+#10#13#10#13+'       file    the file where the string got to be searched and deleted'+#10#13;

var sl: TStringList;
    i, where: Integer;
    found: Boolean;

begin
  writeln(copyright1);
  writeln(copyright2);
  writeln;
  writeln(gpl1);
  writeln(gpl2);
  writeln(gpl3);
  writeln;

  found := false;
  where := -1;

  if not FileExists(ParamStr(1)) then
  begin
    writeln(usage);
    writeln('Error: File ''' + ParamStr(1) + ''' doesn''t exist!');
    exit;
  end;

  sl := TStringList.Create;
  sl.LoadFromFile(ParamStr(1));

  for i := 0 to sl.Count-1 do
  begin
    if sl[i] = '		mov	byte [0],1' then
    begin
      found := true;
      where := i;
    end;
  end;

  if found then
  begin
    writeln('Found: ' + inttostr(where));
    sl.Delete(where);
    sl.SaveToFile(ParamStr(1));
    writeln('Patched!');
  end;
  sl.Free;
end.
