{******************************************************************************
 *  convert.pp - basic converting functions
 *
 *
 *  Copyright (c) 2004 nucleOS Group [http://nucle-os.sourceforge.net/]
 *                                   [http://www.sf.net/projects/nucle-os]
 *                                   [http://www.saint-soft.de/nucleos/board/]
 *
 *  version 0.1 - 15/02/2004 - first release
 *
 *  written by
 *    Michael Gerh"auser (saberrider) [saberrider@users.sourceforge.net]
 *
 *  This file does
 *   - convert string to integer
 *   - convert integer to string
 *   - convert integer to hex-string
 *   - convert string to longint
 *   - convert hex-string to longint
 *
 * This program is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software Foundation
 * (version 2, June 1991)
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program; if not, write to:
 * Free Software Foundation, Inc.
 * 59 Temple Place, Suite 330
 * Boston, MA 02111-1307 USA
 *
 ******************************************************************************}


unit convert;

interface

uses strings, math;

{
function length( value: String ): byte; external name 'LENGTH_STR';
function power( base, exponent: Integer ): Integer; external name 'POWER';
function ord( value: char ): byte; external;
function chr( value: byte ): char; external;
function UpperCase( value: String ): String; external;
}

function IntToStr( value: Integer ): String;
function IntToHexStr( value: Integer ): String;
function IntToHexAligned( value: Integer; Alignment: Byte ): String;
function StrToInt( value: String ): Integer;
function HexToInt( value: String ): Integer;

implementation

type
    TCharSet = set of char;

const
    Hex_Mask: array [0..15] of char = ('0', '1', '2', '3', '4', '5', '6', '7',
                                       '8', '9', 'A', 'B', 'C', 'D', 'E', 'F');
    Dec_Mask: array [0..9] of char = ('0', '1', '2', '3', '4', '5', '6', '7', '8', '9');
    HexSet: TCharSet = ['0', '1', '2', '3', '4', '5', '6', '7',
                         '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'];
    DecSet: TCharSet = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];


function IntToStr( value: Integer ): String; [public, alias : 'INTTOSTR'];
var
   bSigned: Boolean;
   val_, mod_, div_: Integer;
   tmp: String;
begin
     val_ := value;

     if ( val_ < 0 ) then
     begin
        val_  := (-1) * val_;
        bSigned := true;
     end
     else
        bSigned := false;

     tmp := '';
     
     if (val_ = 0) then
        tmp := '0';

     div_ := val_;
     while ( div_ > 0 ) do
     begin
          asm
             xor eax, eax
             xor edx, edx
             xor ebx, ebx
             mov eax, div_
             mov ebx, $A
             div ebx
             mov div_, eax
             mov mod_, edx
          end;

          tmp   := Dec_Mask[mod_] + tmp;
     end;

     if bSigned then
        tmp := '-' + tmp;

    IntToStr := tmp;
end;

function IntToHexStr( value: Integer ): String; [public, alias : 'INTTOHEX'];
var
   mod_, div_: Integer;
   tmp: String;
begin
     if ( value < 0 ) then
     begin
        value  := (-1) * value;
        value := not value;
     end;

     tmp := '';

     if value = 0 then
         tmp := '0';

     while ( value > 0 ) do
     begin
          asm
             xor eax, eax
             xor edx, edx
             xor ebx, ebx
             mov eax, value
             mov ebx, $10
             div ebx
             mov div_, eax
             mov mod_, edx
          end;

          value := div_;
          tmp   := Hex_Mask[mod_] + tmp;
     end;

    tmp := tmp + 'h';

    IntToHexStr := tmp;
end;


function IntToHexAligned( value: Integer; Alignment: Byte ): String; [public, alias : 'INTTOHEXALIGNED'];
var
   mod_, div_: Integer;
   Counter: Byte;
   tmp: String;
begin
     if ( value < 0 ) then
     begin
        value  := (-1) * value;
        value := not value;
     end;

     tmp := '';

     Counter := 0;

     while ( Alignment > Counter ) do
     begin
          asm
             xor eax, eax
             xor edx, edx
             xor ebx, ebx
             mov eax, value
             mov ebx, $10
             div ebx
             mov div_, eax
             mov mod_, edx
          end;

          value := div_;
          Counter += 1;
          tmp   := Hex_Mask[mod_] + tmp;
     end;

    tmp := tmp + 'h';

    IntToHexAligned := tmp;
end;


function StrToInt( value: String ): Integer; [public, alias : 'STRTOINT'];
var
   i, j: byte;
   tmp: Integer;
   bSigned: Boolean;
begin
     if value[1] = '-' then
     begin
       value[1] := '0';
       bSigned := true;
     end
     else
       bSigned := false;

     tmp := 0;

     for i := length( value ) downto 1 do
     begin
         	if ( not (value[length( value ) - i + 1] in DecSet) ) then
         	begin
                    StrToInt := 0;
         	    	exit;
            end
            else
            begin
                	j := Ord( value[length( value ) - i + 1] ) - 48;
                	tmp := tmp + j * power( 10, i-1 );
            end;
     end;

     if bSigned then
        tmp := (-1) * tmp;

     StrToInt := tmp;
end;

function HexToInt( value: String ): Integer; [public, alias:'HEXTOINT'];
var
   i, j: byte;
   tmp: Integer;
begin
     value := UpperCase( value );

     tmp := 0;

     for i := length( value ) downto 1 do
     begin
         	if ( not (value[length( value ) - i + 1] in HexSet) ) then
         	begin
                    HexToInt := 0;
         	    	exit;
            end
            else
            begin
                	if ( Ord( value[length( value ) - i + 1] ) < 58 ) then
                       j := Ord( value[length( value ) - i + 1] ) - 48
                    else
                       j := Ord( value[length( value ) - i + 1] ) - 55;
                	tmp := tmp + j * power( 16, i-1 );
            end;
     end;

     HexToInt := tmp;
end;


begin
end.

