;****************************************************************************************
;* gdt.s - sets up and loads our GDT
;*
;* written by Michael Gerh"auser (saberrider), programmer of nucleOS
;*
;*
;* EXPORTS: procedure setup_gdt (used by kernel): sets up and loads the GDT
;*
;*
;* Copyright (C) 2004 by nucleOS group
;*
;* This program is free software; you can redistribute it and/or modify it under the
;* terms of the GNU General Public License as published by the Free Software Foundation
;* (version 2, June 1991)
;*
;* This program is distributed in the hope that it will be useful, but WITHOUT ANY
;* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
;* PARTICULAR PURPOSE. See the GNU General Public License for more details.
;*
;* You should have received a copy of the GNU General Public License along with this
;* program; if not, write to:
;* Free Software Foundation, Inc.
;* 59 Temple Place, Suite 330
;* Boston, MA 02111-1307 USA
;*
;*
;* You can contact me by electronic mail: saberrider@users.sourceforge.net
;****************************************************************************************

BITS 32

; Base Address, where GDT is stored
GDT_LOCATION	equ	0


SECTION .text

; ........................................................
; This is the main procedure. It sets up the GDT and
; loads it
;
; INPUT:
;	stack:
;		+---------------------------------------+
;		|           adress of GDT-base          |
;		+---------------------------------------+
;		|                 ...                   |
;
; ........................................................
	GLOBAL SETUP_GDT
	SETUP_GDT:
        push ebp        ;
        mov ebp, esp    ; FPC's procedure enter code

		; save registers (so they can be restored later)
		push eax
		push ecx
		push edi

        ; to avoid crash restore original segment registers...

		mov ax, 0x28
		mov ds, ax
		mov es, ax
		mov fs, ax
		mov gs, ax
		mov ss, ax

	; including cs:

		jmp 0x20:restore_orig_cs
		restore_orig_cs:

		cli

		lgdt [gdt_reg]				; LOAD GDT

		jmp 0x08:flush
		flush:

		;re-initialize segment registers
		mov ax, 0x10
		mov ds, ax
		mov es, ax
		mov fs, ax
		mov gs, ax
		mov ss, ax

	; segment registers (cs-gs & ss) now point to valid code/data segment in cpr0
	; so we can now change remaining two segments

		; fix cpr1_data
		mov byte [chg_old_code], 0xB2
		; fix cpr2_code
		mov byte [chg_old_data], 0xDA
		; done reinitializing GDT

	        sti

		pop edi
		pop ecx
		pop eax
		pop edx

		mov eax, gdt
		
		leave
		retn


SECTION .data

; Global Variables to access the right segments
;
; !!! IMPORTANT !!!
;
; _ALL_ segment register changes should be changed
; using this variables

GLOBAL _CPR0_CODE
_CPR0_CODE: dw 0x08
GLOBAL _CPR0_DATA
_CPR0_DATA: dw 0x10

GLOBAL _CPR1_CODE
_CPR1_CODE: dw 0x18
GLOBAL _CPR1_DATA
_CPR1_DATA: dw 0x20

GLOBAL _CPR2_CODE
_CPR2_CODE: dw 0x28
GLOBAL _CPR2_DATA
_CPR2_DATA: dw 0x30

GLOBAL _CPR3_CODE
_CPR3_CODE: dw 0x38
GLOBAL _CPR3_DATA
_CPR3_DATA: dw 0x40

GLOBAL _TSS_DESC_SEL
_TSS_DESC_SEL: dw 0x48

; this is loaded in the CPU register ( lgdt [gdt_reg] )

gdt_reg:
	dw gdt_end - gdt - 1   	; GDT limit
	dd gdt			; (GDT base gets set above)

; null-segment
gdt:
	dw 0			; limit 15:0
	dw 0			; base 15:0
	db 0			; base 24:15
	db 0			; P + DPL + S + type
	db 0			; limit 19:16, flags
	db 0			; base 31:24

; cpr0code
gdt1:
	dw 0xFFFF		; limit 0xFFFFF
	dw 0			; base 0
	db 0
	db 10011010b		; P + DPL + S + type
    db 11001111b		; limit 19:16, flags
	db 0

;cpr0data
gdt2:
    dw 0xFFFF               ; limit 0xFFFFF
	dw 0			; base
	db 0
	db 10010010b		; P + DPL + S + type
    db 11001111b		; limit 19:16, flags
	db 0

;cpr1code
gdt3:
    dw 0xFFFF               ; limit 0xFFFFF
	dw 0			; base
	db 0
	db 10111010b		; P + DPL + S + type
    db 11001111b		; limit 19:16, flags
	db 0

;cpr1data
gdt4:
    dw 0xFFFF               ; limit 0xFFFFF
	dw 0			; base
	db 0
	; our old kernel_code selector!
	; we need to leave this 10011010b (9A) and change it after loading
	; new gdt to 10110010b (B2)
chg_old_code:
	db 10110010b		; P + DPL + S + type
    db 11001111b		; limit 19:16, flags
	db 0

;cpr2code
gdt5:
    dw 0xFFFF               ; limit 0xFFFFF
	dw 0			; base
	db 0
	; our old kernel_data selector!
	; we need to leave this 10010010b (92) and change it after loading
	; new gdt to 11011010b (DA)
chg_old_data:
	db 10010010b		; P + DPL + S + type
    db 11001111b		; limit 19:16, flags
	db 0

;cpr2data
gdt6:
    dw 0xFFFF               ; limit 0xFFFFF
	dw 0			; base
	db 0
	db 11010010b		; P + DPL + S + type
    db 11001111b		; limit 19:16, flags
	db 0

;cpr3code
gdt7:
    dw 0xFFFF               ; limit 0xFFFFF
	dw 0			; base
	db 0
	db 11111010b		; P + DPL + S + type
    db 11001111b		; limit 19:16, flags
	db 0

;cpr3data
gdt8:
    dw 0xFFFF               ; limit 0xFFFFF
	dw 0			; base
	db 0
	db 11110010b		; P + DPL + S + type
    db 11001111b		; limit 19:16, flags
	db 0

;our tss-descriptor
dummy_tss:
    dw 0
    dw 0
    db 0
    db 0
    db 0
    db 0

gdt_end:

SECTION .bss
