{******************************************************************************
 *  math.pp - basic mathematical functions and constants
 *
 *
 *  Copyright (c) 2004 nucleOS Group [http://nucle-os.sourceforge.net/]
 *                                   [http://www.sf.net/projects/nucle-os]
 *                                   [http://www.saint-soft.de/nucleos/board/]
 *
 *  version 0.1 - 19/02/2004 - initial release
 *
 *  written by
 *    Michael Gerh"auser (saberrider) [saberrider@users.sourceforge.net]
 *
 *  This file does
 *   - implement basic mathematical functions
 *
 *  To be implemented
 *   - %
 *
 * This program is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software Foundation
 * (version 2, June 1991)
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program; if not, write to:
 * Free Software Foundation, Inc.
 * 59 Temple Place, Suite 330
 * Boston, MA 02111-1307 USA
 *
 ******************************************************************************}


unit math;


interface

{* Procedures and functions defined in this file *}

function power( base, exponent: Integer ): Integer;
//function power( base, exponent: extended ): extended;

implementation

{* Constants only used in this fiel *}


{******************************************************************************
 *   power
 ******************************************************************************
 *  does:
 *   calculates base^exponent
 *
 *  thanks to obbschtkuche for giving us a hint to this function
 *
 ******************************************************************************}
function power( base, exponent: Integer ): Integer; [public, alias:'POWER'];
begin
     if ( base = 0 ) then
     begin
         	power := 0;
         	exit;
     end
     else if ( exponent <= 0 ) then
     begin
         	power := 1;
         	exit;
     end;

     if ( exponent mod 2 = 0 ) then
          power := power ( base * base, exponent div 2 )
     else
          power := base * power ( base, exponent - 1 );

end;

{function power( base, exponent: Extended ): Extended; [public, alias:'POWER_EXT'];
var
   i: Integer;
   tmp: Extended;
begin
     if ( base = 0 ) then
     begin
         	power := 0;
         	exit;
     end
     else if ( exponent <= 0 ) then
     begin
         	power := 1;
         	exit;
     end;

     tmp := base;

     for i := 1 to exponent-1 do
     begin
         	tmp := tmp * base;
     end;

     power := tmp;
end;}


begin
end.

