import icommand.platform.nxt.*;
import icommand.nxtcomm.*;
import icommand.robotics.*;

public class SoundTest {

	public static void usage() {
		System.out.println("Usage:");
		System.out.println("  java SoundTest <duration>");
		System.out.println("");
		System.out.println("     duration:     Integeger between 1 and 30");
	}

	public static void main(String[] args) {
		if(args.length < 1) {
			usage();
			return;
		}

		int duration = Integer.parseInt(args[0]);
		if(duration > 30)
			duration = 30;
		duration = duration * 1000;

		Sound s = new Sound(Sensor.S2);

		int d = s.getdB();
		long start = System.currentTimeMillis();
		for(int i=0; i<99; i++) {
			System.currentTimeMillis();
		}

		System.out.println("Für den Aufruf von 100x System.currentTimeMillis() benötigte Zeit: " + (System.currentTimeMillis() - start));

		System.out.println("Ab jetzt: Messung der Aufrufdauer von Touch.isPressed():");
		start = System.currentTimeMillis();
		long last_time = System.currentTimeMillis();
		while(System.currentTimeMillis() - start < duration) {
			d = s.getdB();
			System.out.println("Benötigte Zeit: " + (System.currentTimeMillis()-last_time) + "ms, zurückgegebener Wert: " + d);
			last_time = System.currentTimeMillis();
		}

	        NXTCommand.close();
	}
}

