/*
 * Decompiled with CFR 0.152.
 */
package icommand.platform.nxt;

import icommand.platform.nxt.I2CSensor;
import icommand.platform.nxt.Sensor;

public class Ultrasonic
extends I2CSensor {
    private static byte FACTORY_ZERO = (byte)17;
    private static byte FACTORY_SCALE_FACTOR = (byte)18;
    private static byte FACTORY_SCALE_DIVISOR = (byte)19;
    private static byte MEASUREMENT_UNITS = (byte)20;
    private static byte CONTINUOUS_MEASUREMENT_INTERVAL = (byte)64;
    private static byte COMMAND_STATE = (byte)65;
    private static byte BYTE0 = (byte)66;
    private static byte BYTE1 = (byte)67;
    private static byte BYTE2 = (byte)68;
    private static byte BYTE3 = (byte)69;
    private static byte BYTE4 = (byte)70;
    private static byte BYTE5 = (byte)71;
    private static byte BYTE6 = (byte)72;
    private static byte BYTE7 = (byte)73;
    private static byte ACTUAL_ZERO = (byte)80;
    private static byte ACTUAL_SCALE_FACTOR = (byte)81;
    private static byte ACTUAL_SCALE_DIVISOR = (byte)82;
    private static byte OFF = 0;
    private static byte SINGLE_SHOT = 1;
    private static byte CONTINUOUS_MEASUREMENT = (byte)2;
    private static byte EVENT_CAPTURE = (byte)3;
    private static byte REQUEST_WARM_RESET = (byte)4;

    public Ultrasonic(Sensor sensor) {
        super(sensor, (byte)11);
    }

    public void setSensorMode(byte by) {
        this.setData(COMMAND_STATE, by);
    }

    public int getDistance() {
        this.setSensorMode(SINGLE_SHOT);
        byte[] byArray = this.getData(BYTE0, 1);
        return 0xFF & byArray[0];
    }

    public void setMetric(boolean bl) {
    }

    public byte[] getDistances() {
        this.setSensorMode(SINGLE_SHOT);
        return this.getData(BYTE0, 8);
    }

    public int getMeasurementInterval() {
        byte by = this.getData(CONTINUOUS_MEASUREMENT_INTERVAL, 1)[0];
        return 0xFF & by;
    }

    public void setScaleFactor(byte by) {
        this.setData(ACTUAL_SCALE_FACTOR, by);
    }

    public void setZero(byte by) {
        this.setData(ACTUAL_ZERO, by);
    }

    public void setScaleDivisor(byte by) {
        this.setData(ACTUAL_SCALE_DIVISOR, by);
    }

    public void calibrate(byte by, byte by2, byte by3) {
        this.setScaleFactor(by);
        this.setScaleDivisor(by2);
        this.setZero(by3);
    }

    public int getScaleFactor() {
        byte[] byArray = this.getData(ACTUAL_SCALE_FACTOR, 1);
        return 0xFF & byArray[0];
    }

    public int getFactoryScaleFactor() {
        byte[] byArray = this.getData(FACTORY_SCALE_FACTOR, 1);
        return 0xFF & byArray[0];
    }

    public int getFactoryScaleDivisor() {
        byte[] byArray = this.getData(FACTORY_SCALE_DIVISOR, 1);
        return 0xFF & byArray[0];
    }

    public int getFactoryZero() {
        byte[] byArray = this.getData(FACTORY_ZERO, 1);
        return 0xFF & byArray[0];
    }

    public void setMeasurementInterval(byte by) {
        this.setData(CONTINUOUS_MEASUREMENT_INTERVAL, by);
    }

    public String getMeasurementUnits() {
        return this.fetchString(MEASUREMENT_UNITS, 7);
    }
}

