import icommand.platform.nxt.*;
import icommand.nxtcomm.*;
import icommand.robotics.*;
import icommand.vision.*;

/*
 *  Programm zum Folgen einer Linie
 *
 *  Sollte in Verbindung mit einem Tribot genutzt werden.
 *  Lichtsensor an Sensorport 3
 *  Linkes Rad an Motor C, Rechtes Rad an Motor B
 *
 *  Lässt den Tribot geradeaus fahren, bis eine andere Farbe
 *  als schwarz ausgelesen wird und beginnt dann nach schwarzer Fläche
 *  zu suchen. Erst nach rechts, 6 mal 5 Grad, dann zurück und
 *  nach links 30 Grad in 5 Grad-Schritten. Wird nichts gefunden
 *  bricht das Programm ab.
 */

public class FollowTheLine implements Runnable {
    private Light licht;
    private SyncMotors motor;
    private ServoNavigator lenkrad;
    private int pathColorValue;
    private int pathColorTolerance;

    public void debug(String s) {
        // Falls keine Ausgabe gewünscht, folgende Zeile auskommentieren
    	System.out.println(s);
    }

    public static void main(String[] args) {
    	FollowTheLine app = new FollowTheLine();
    	app.run();
    }

    public FollowTheLine() {
    	licht = new Light(Sensor.S3);
	    motor = new SyncMotors(Motor.B, Motor.C);
    	motor.setSpeed(24);
	    lenkrad = new ServoNavigator(56.0, 11.5, 360.0, motor);
    	pathColorValue = 45;
	    pathColorTolerance = 12;
    }

    public boolean isColorAccepted(int color) {
    	debug("isColorAccepted: " + color);
    	return (Math.abs(color-pathColorValue) <= pathColorTolerance);
    }

    public void walkPath() {
    	debug("This is walkPath getting called");
    	lenkrad.forward();
    	debug("moving forward");
        int color = licht.getLightPercent();
        long time = System.currentTimeMillis();

        while(isColorAccepted(color)) {
            if( System.currentTimeMillis() - time > 75 ) {
                color = licht.getLightPercent();
                time = System.currentTimeMillis();
                debug("Farbe: " + color);
            }
        }
    	lenkrad.stop();
    }

    public boolean findPath() {
    	debug("This is findPath() getting called");

        int color = licht.getLightPercent();
    	double current_angle = lenkrad.getAngle();

    	debug("Entering rotation -- RIGHT");
    	while(!isColorAccepted(color) && ( lenkrad.getAngle()-current_angle <= 30.0  )) {
            lenkrad.rotate(5.0);
    		color = licht.getLightPercent();
        }

    	debug((isColorAccepted(color) ? "found" : "could'nt find") + " good color");
    	if(!isColorAccepted(color))
    	    lenkrad.rotateBackwards(-30.0);

        debug ("Entering rotation -- LEFT");
    	while(!isColorAccepted(color) && ( lenkrad.getAngle()-current_angle >= -30.0)) {
    		lenkrad.rotate(-5.0);
    		color = licht.getLightPercent();
        }

    	debug((isColorAccepted(color) ? "found" : "could'nt find") + " good color");

    	debug("returning from findPath()");
    	return isColorAccepted(color);
    }
    
    public void run() {
    	while(findPath())
    	    walkPath();

        NXTCommand.close();
    }
}

