/*
 * Decompiled with CFR 0.152.
 */
package icommand.vision;

import icommand.vision.ColorDetectionControl;
import icommand.vision.LightListener;
import icommand.vision.Region;
import icommand.vision.Vision;
import icommand.vision.VisionEffect;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public class ColorEffect
extends VisionEffect {
    private static final int INIT_PIXEL_THRESHOLD = 16;
    private static final int LIGHT_THRESHOLD = 192;
    public static final int MAX_PIXEL_THRESHOLD = 40;
    public static final int MIN_PIXEL_THRESHOLD = 0;
    public static final int PIXEL_THRESHOLD_INC = 4;
    public static final float INIT_PROPORTION = 0.25f;
    public static final float MAX_PROPORTION = 0.5f;
    public static final float MIN_PROPORTION = 0.05f;
    public static final float PROPORTION_INC = 0.05f;
    public int[] averageRed = new int[Region.MAX_REGIONS];
    public int[] averageGreen = new int[Region.MAX_REGIONS];
    public int[] averageBlue = new int[Region.MAX_REGIONS];
    public static int pixelThreshold = 16;
    public static float requiredProportion = 0.25f;
    private Control[] controls;

    public int process(Buffer buffer, Buffer buffer2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        Object[] objectArray;
        int n12;
        int n13 = ((VideoFormat)this.outputFormat).getMaxDataLength();
        this.validateByteArraySize(buffer2, n13);
        buffer2.setLength(n13);
        buffer2.setFormat(this.outputFormat);
        buffer2.setFlags(buffer.getFlags());
        byte[] byArray = (byte[])buffer.getData();
        byte[] byArray2 = (byte[])buffer2.getData();
        RGBFormat rGBFormat = (RGBFormat)buffer.getFormat();
        Dimension dimension = rGBFormat.getSize();
        int n14 = rGBFormat.getPixelStride();
        int n15 = rGBFormat.getLineStride();
        if (byArray2.length < dimension.width * dimension.height * 3) {
            System.out.println("the buffer is not full");
            return 1;
        }
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        Region[] regionArray = Vision.getRegions();
        int n16 = -1;
        int n17 = -1;
        float f = -1.0f;
        for (n12 = 0; n12 < regionArray.length; ++n12) {
            if (regionArray[n12] == null) continue;
            objectArray = regionArray[n12].getColorListeners();
            int[] nArray = regionArray[n12].getColors();
            if (objectArray.length == 0) continue;
            n11 = regionArray[n12].getX();
            n10 = regionArray[n12].getY();
            n9 = regionArray[n12].getWidth();
            n8 = regionArray[n12].getHeight();
            for (n7 = 0; n7 < objectArray.length; ++n7) {
                float f2;
                n6 = nArray[n7] >> 16 & 0xFF;
                int n18 = nArray[n7] >> 8 & 0xFF;
                n5 = nArray[n7] & 0xFF;
                n4 = 0;
                n3 = 0;
                n2 = 0;
                n = 0;
                int n19 = 0;
                for (int i = n10; i < n10 + n8; ++i) {
                    for (int j = n11; j < n11 + n9; ++j) {
                        int n20 = i * n15 + j * n14;
                        int n21 = byArray[n20 + 2] & 0xFF;
                        int n22 = byArray[n20 + 1] & 0xFF;
                        int n23 = byArray[n20] & 0xFF;
                        n2 += n21;
                        n += n22;
                        n19 += n23;
                        ++n3;
                        if (Math.abs(n21 - n6) > pixelThreshold || Math.abs(n22 - n18) > pixelThreshold || Math.abs(n23 - n5) > pixelThreshold) continue;
                        ++n4;
                    }
                }
                this.averageRed[n12] = n2 / n3;
                this.averageGreen[n12] = n / n3;
                this.averageBlue[n12] = n19 / n3;
                if (Vision.captureColor) {
                    System.out.println("Color = " + n2 / n3 + " , " + n / n3 + " , " + n19 / n3);
                }
                if (!((f2 = (float)n4 / (float)n3) > f) || !(f2 > requiredProportion)) continue;
                f = f2;
                n16 = n12;
                n17 = n7;
            }
        }
        if (n16 >= 0) {
            regionArray[n16].getColorListeners()[n17].colorDetected(n16 + 1, regionArray[n16].getColors()[n17]);
        }
        n16 = -1;
        n17 = -1;
        f = -1.0f;
        for (n12 = 0; n12 < regionArray.length; ++n12) {
            if (regionArray[n12] == null || (objectArray = regionArray[n12].getLightListeners()).length == 0) continue;
            int n24 = regionArray[n12].getX();
            n11 = regionArray[n12].getY();
            n10 = regionArray[n12].getWidth();
            n9 = regionArray[n12].getHeight();
            for (n8 = 0; n8 < objectArray.length; ++n8) {
                n7 = 0;
                n6 = 0;
                for (int i = n11; i < n11 + n9; ++i) {
                    for (n5 = n24; n5 < n24 + n10; ++n5) {
                        n4 = i * n15 + n5 * n14;
                        n3 = byArray[n4 + 2] & 0xFF;
                        n2 = byArray[n4 + 1] & 0xFF;
                        n = byArray[n4] & 0xFF;
                        ++n6;
                        if (n3 < 192 || n2 < 192 || n < 192) continue;
                        ++n7;
                    }
                }
                float f3 = (float)n7 / (float)n6;
                if (!(f3 > f) || !(f3 > requiredProportion)) continue;
                f = f3;
                n16 = n12;
                n17 = n8;
            }
        }
        if (n16 > 0) {
            LightListener[] lightListenerArray = regionArray[n16].getLightListeners();
            for (int i = 0; i < lightListenerArray.length; ++i) {
                lightListenerArray[i].lightDetected(n16 + 1);
            }
        }
        return 0;
    }

    public String getName() {
        return "Color Effect";
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[1];
            this.controls[0] = new ColorDetectionControl(this);
        }
        return this.controls;
    }
}

