/*
 * Decompiled with CFR 0.152.
 */
package icommand.nxtcomm;

import icommand.nxtcomm.AsciizCodec;
import icommand.nxtcomm.DeviceInfo;
import icommand.nxtcomm.FileInfo;
import icommand.nxtcomm.FirmwareInfo;
import icommand.nxtcomm.InputValues;
import icommand.nxtcomm.NXTComm;
import icommand.nxtcomm.NXTProtocol;
import icommand.nxtcomm.OutputState;

public class NXTCommand
implements NXTProtocol {
    private static boolean verifyCommand = false;

    private NXTCommand() {
    }

    public static byte startProgram(String string) {
        byte[] byArray = new byte[]{-128, 0};
        byArray = NXTCommand.appendString(byArray, string);
        return NXTCommand.sendRequest(byArray);
    }

    public static byte stopProgram() {
        byte[] byArray = new byte[]{-128, 1};
        return NXTCommand.sendRequest(byArray);
    }

    public static String getCurrentProgramName() {
        byte[] byArray = new byte[]{0, 17};
        NXTComm.sendData(byArray);
        byte[] byArray2 = NXTComm.readData();
        return new StringBuffer(new String(byArray2)).delete(0, 2).toString();
    }

    public static FileInfo openRead(String string) {
        byte[] byArray = new byte[]{1, -128};
        byArray = NXTCommand.appendString(byArray, string);
        NXTComm.sendData(byArray);
        byte[] byArray2 = NXTComm.readData();
        FileInfo fileInfo = new FileInfo(string);
        fileInfo.status = byArray2[2];
        if (byArray2.length > 3) {
            fileInfo.fileHandle = byArray2[3];
            fileInfo.fileSize = 0xFF & byArray2[4] | (0xFF & byArray2[5]) << 8 | (0xFF & byArray2[6]) << 16 | (0xFF & byArray2[7]) << 24;
        }
        return fileInfo;
    }

    public static byte openWrite(String string, int n) {
        byte[] byArray = new byte[]{1, -127};
        byte[] byArray2 = AsciizCodec.encode(string);
        byArray = NXTCommand.appendBytes(byArray, byArray2);
        byte[] byArray3 = new byte[22];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        byte[] byArray4 = new byte[]{(byte)n, (byte)(n >>> 8), (byte)(n >>> 16), (byte)(n >>> 24)};
        byArray3 = NXTCommand.appendBytes(byArray3, byArray4);
        NXTComm.sendData(byArray3);
        byte[] byArray5 = NXTComm.readData();
        return byArray5[3];
    }

    public static byte[] readFile(byte by, int n) {
        byte[] byArray = new byte[]{1, -126, by, (byte)n, (byte)(n >>> 8)};
        NXTComm.sendData(byArray);
        byte[] byArray2 = NXTComm.readData();
        byte[] byArray3 = new byte[byArray2.length - 6];
        System.arraycopy(byArray2, 6, byArray3, 0, byArray3.length);
        return byArray3;
    }

    public static byte writeFile(byte by, byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 3];
        byte[] byArray3 = new byte[]{-127, -125, by};
        System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
        System.arraycopy(byArray, 0, byArray2, 3, byArray.length);
        byte by2 = 0;
        if (verifyCommand) {
            byArray2[0] = 1;
        }
        NXTComm.sendData(byArray2);
        if (verifyCommand) {
            byte[] byArray4 = NXTComm.readData();
            by2 = byArray4[2];
        }
        return by2;
    }

    public static byte closeFile(byte by) {
        byte[] byArray = new byte[]{-127, -124, by};
        byte by2 = 0;
        if (verifyCommand) {
            byArray[0] = 1;
        }
        NXTComm.sendData(byArray);
        if (verifyCommand) {
            byte[] byArray2 = NXTComm.readData();
            by2 = byArray2[2];
        }
        return by2;
    }

    public static byte delete(String string) {
        byte[] byArray = new byte[]{1, -123};
        byArray = NXTCommand.appendString(byArray, string);
        NXTComm.sendData(byArray);
        byte[] byArray2 = NXTComm.readData();
        return byArray2[2];
    }

    public static FirmwareInfo getFirmwareVersion() {
        byte[] byArray = new byte[]{1, -120};
        NXTComm.sendData(byArray);
        byte[] byArray2 = NXTComm.readData();
        FirmwareInfo firmwareInfo = new FirmwareInfo();
        firmwareInfo.status = byArray2[2];
        if (firmwareInfo.status == 0) {
            firmwareInfo.protocolVersion = new String(byArray2[4] + "." + byArray2[3]);
            firmwareInfo.firmwareVersion = new String(byArray2[6] + "." + byArray2[5]);
        } else {
            System.out.println("Status = " + firmwareInfo.status);
        }
        return firmwareInfo;
    }

    public static byte setBrickName(String string) {
        byte[] byArray = new byte[]{1, 0};
        byArray = NXTCommand.appendString(byArray, string);
        NXTComm.sendData(byArray);
        byte[] byArray2 = NXTComm.readData();
        return byArray2[2];
    }

    public static DeviceInfo getDeviceInfo() {
        byte[] byArray = new byte[]{1, -101};
        NXTComm.sendData(byArray);
        byte[] byArray2 = NXTComm.readData();
        DeviceInfo deviceInfo = new DeviceInfo();
        deviceInfo.status = byArray2[2];
        deviceInfo.NXTname = new StringBuffer(new String(byArray2)).delete(18, 33).delete(0, 3).toString();
        deviceInfo.bluetoothAddress = Integer.toHexString(byArray2[18]) + ":" + Integer.toHexString(byArray2[19]) + ":" + Integer.toHexString(byArray2[20]) + ":" + Integer.toHexString(byArray2[21]) + ":" + Integer.toHexString(byArray2[22]) + ":" + Integer.toHexString(byArray2[23]) + ":" + Integer.toHexString(byArray2[24]);
        deviceInfo.signalStrength = 0xFF & byArray2[25] | (0xFF & byArray2[26]) << 8 | (0xFF & byArray2[27]) << 16 | (0xFF & byArray2[28]) << 24;
        deviceInfo.freeFlash = 0xFF & byArray2[29] | (0xFF & byArray2[30]) << 8 | (0xFF & byArray2[31]) << 16 | (0xFF & byArray2[32]) << 24;
        return deviceInfo;
    }

    public static byte deleteUserFlash() {
        byte[] byArray = new byte[]{1, -96};
        NXTComm.sendData(byArray);
        byte[] byArray2 = NXTComm.readData();
        return byArray2[2];
    }

    public static byte pollLength(byte by) {
        byte[] byArray = new byte[]{1, -95, by};
        NXTComm.sendData(byArray);
        byte[] byArray2 = NXTComm.readData();
        return byArray2[4];
    }

    public static byte[] poll(byte by, byte by2) {
        byte[] byArray = new byte[]{1, -94, by, by2};
        NXTComm.sendData(byArray);
        byte[] byArray2 = NXTComm.readData();
        byte by3 = byArray2[4];
        byte[] byArray3 = new byte[by3];
        if (byArray2[3] == 0) {
            System.out.println("Poll length is : " + by3);
            System.out.println("Array length is : " + byArray2.length + " (should be 4 less than Poll length).");
            System.arraycopy(byArray2, 5, byArray3, 0, by3);
        }
        return byArray3;
    }

    public static FileInfo findFirst(String string) {
        byte[] byArray = new byte[]{1, -122};
        byArray = NXTCommand.appendString(byArray, string);
        NXTComm.sendData(byArray);
        byte[] byArray2 = NXTComm.readData();
        FileInfo fileInfo = null;
        if (byArray2[2] == 0) {
            fileInfo = new FileInfo("");
            fileInfo.status = byArray2[2];
            if (byArray2.length > 3) {
                fileInfo.fileHandle = byArray2[3];
                StringBuffer stringBuffer = new StringBuffer(new String(byArray2)).delete(24, 27).delete(0, 4);
                int n = stringBuffer.indexOf(".") + 4;
                stringBuffer.delete(n, stringBuffer.length());
                fileInfo.fileName = stringBuffer.toString();
                fileInfo.fileSize = 0xFF & byArray2[24] | (0xFF & byArray2[25]) << 8 | (0xFF & byArray2[26]) << 16 | (0xFF & byArray2[27]) << 24;
            }
        }
        return fileInfo;
    }

    public static FileInfo findNext(byte by) {
        byte[] byArray = new byte[]{1, -121, by};
        NXTComm.sendData(byArray);
        byte[] byArray2 = NXTComm.readData();
        FileInfo fileInfo = null;
        if (byArray2[2] == 0) {
            fileInfo = new FileInfo("");
            fileInfo.status = byArray2[2];
            if (byArray2.length > 3) {
                fileInfo.fileHandle = byArray2[3];
                StringBuffer stringBuffer = new StringBuffer(new String(byArray2)).delete(24, 27).delete(0, 4);
                int n = stringBuffer.indexOf(".") + 4;
                stringBuffer.delete(n, stringBuffer.length());
                fileInfo.fileName = stringBuffer.toString();
                fileInfo.fileSize = 0xFF & byArray2[24] | (0xFF & byArray2[25]) << 8 | (0xFF & byArray2[26]) << 16 | (0xFF & byArray2[27]) << 24;
            }
        }
        return fileInfo;
    }

    public static byte playSoundFile(String string, boolean bl) {
        byte by = 0;
        if (bl) {
            by = -1;
        }
        byte[] byArray = new byte[]{-128, 2, by};
        byte[] byArray2 = AsciizCodec.encode(string);
        byArray = NXTCommand.appendBytes(byArray, byArray2);
        return NXTCommand.sendRequest(byArray);
    }

    public static byte stopSoundPlayback() {
        byte[] byArray = new byte[]{-128, 12};
        return NXTCommand.sendRequest(byArray);
    }

    private static byte[] appendString(byte[] byArray, String string) {
        String string2 = new String(byArray);
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append(string);
        stringBuffer.setLength(stringBuffer.length() + 1);
        return stringBuffer.toString().getBytes();
    }

    private static byte[] appendBytes(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static byte setOutputState(int n, byte by, int n2, int n3, int n4, int n5, int n6) {
        byte[] byArray = new byte[]{-128, 4, (byte)n, by, (byte)n2, (byte)n3, (byte)n4, (byte)n5, (byte)n6, (byte)(n6 >>> 8), (byte)(n6 >>> 16), (byte)(n6 >>> 24)};
        return NXTCommand.sendRequest(byArray);
    }

    public static byte setInputMode(int n, int n2, int n3) {
        byte[] byArray = new byte[]{-128, 5, (byte)n, (byte)n2, (byte)n3};
        return NXTCommand.sendRequest(byArray);
    }

    public static OutputState getOutputState(int n) {
        byte[] byArray = new byte[]{0, 6, (byte)n};
        NXTComm.sendData(byArray);
        byte[] byArray2 = NXTComm.readData();
        OutputState outputState = new OutputState(n);
        outputState.status = byArray2[2];
        outputState.outputPort = byArray2[3];
        outputState.powerSetpoint = byArray2[4];
        outputState.mode = byArray2[5];
        outputState.regulationMode = byArray2[6];
        outputState.turnRatio = byArray2[7];
        outputState.runState = byArray2[8];
        outputState.tachoLimit = 0xFF & byArray2[9] | (0xFF & byArray2[10]) << 8 | (0xFF & byArray2[11]) << 16 | (0xFF & byArray2[12]) << 24;
        outputState.tachoCount = 0xFF & byArray2[13] | (0xFF & byArray2[14]) << 8 | (0xFF & byArray2[15]) << 16 | (0xFF & byArray2[16]) << 24;
        outputState.blockTachoCount = 0xFF & byArray2[17] | (0xFF & byArray2[18]) << 8 | (0xFF & byArray2[19]) << 16 | (0xFF & byArray2[20]) << 24;
        outputState.rotationCount = 0xFF & byArray2[21] | (0xFF & byArray2[22]) << 8 | (0xFF & byArray2[23]) << 16 | (0xFF & byArray2[24]) << 24;
        return outputState;
    }

    public static InputValues getInputValues(int n) {
        byte[] byArray = new byte[]{0, 7, (byte)n};
        NXTComm.sendData(byArray);
        byte[] byArray2 = NXTComm.readData();
        InputValues inputValues = new InputValues();
        inputValues.inputPort = byArray2[3];
        inputValues.valid = byArray2[4] != 0;
        inputValues.isCalibrated = byArray2[5] == 0;
        inputValues.sensorType = byArray2[6];
        inputValues.sensorMode = byArray2[7];
        inputValues.rawADValue = 0xFF & byArray2[8] | (0xFF & byArray2[9]) << 8;
        inputValues.normalizedADValue = 0xFF & byArray2[10] | (0xFF & byArray2[11]) << 8;
        inputValues.scaledValue = (short)(0xFF & byArray2[12] | byArray2[13] << 8);
        inputValues.calibratedValue = (short)(0xFF & byArray2[14] | byArray2[15] << 8);
        return inputValues;
    }

    public static byte resetScaledInputValue(int n) {
        byte[] byArray = new byte[]{-128, 8, (byte)n};
        return NXTCommand.sendRequest(byArray);
    }

    public static byte messageWrite(String string, byte by) {
        byte[] byArray = new byte[]{-128, 9, by, (byte)(string.length() + 1)};
        byArray = NXTCommand.appendString(byArray, string);
        return NXTCommand.sendRequest(byArray);
    }

    public static String messageRead(byte by, byte by2, boolean bl) {
        byte[] byArray = new byte[]{0, 19};
        NXTComm.sendData(byArray);
        byte[] byArray2 = NXTComm.readData();
        return new StringBuffer(new String(byArray2)).delete(0, 4).toString();
    }

    public static byte resetMotorPosition(int n, boolean bl) {
        byte by = 0;
        if (bl) {
            by = -1;
        }
        byte[] byArray = new byte[]{-128, 10, (byte)n, by};
        return NXTCommand.sendRequest(byArray);
    }

    public static byte playTone(int n, int n2) {
        byte[] byArray = new byte[]{-128, 3, (byte)n, (byte)(n >>> 8), (byte)n2, (byte)(n2 >>> 8)};
        return NXTCommand.sendRequest(byArray);
    }

    public static int getBatteryLevel() {
        byte[] byArray = new byte[]{0, 11};
        NXTComm.sendData(byArray);
        byte[] byArray2 = NXTComm.readData();
        if (byArray2[1] != 11) {
            System.out.println("Weird data reply received.");
        }
        if (byArray2[2] != 0) {
            System.out.println("NXT reports the check battery command did not work.");
        }
        int n = 0xFF & byArray2[3] | (0xFF & byArray2[4]) << 8;
        return n;
    }

    public static long keepAlive() {
        byte[] byArray = new byte[]{0, 13};
        NXTComm.sendData(byArray);
        byte[] byArray2 = NXTComm.readData();
        int n = 0xFF & byArray2[3] | (0xFF & byArray2[4]) << 8 | (0xFF & byArray2[5]) << 16 | (0xFF & byArray2[6]) << 24;
        return n;
    }

    public static byte[] LSGetStatus(byte by) {
        byte[] byArray = new byte[]{0, 14, by};
        NXTComm.sendData(byArray);
        byte[] byArray2 = NXTComm.readData();
        if (byArray2[2] == -35) {
            System.out.println("NXTCommand.LSGetStatus() error: Communications Bus Error");
        } else if (byArray2[2] == 32) {
            System.out.println("NXTCommand.LSGetStatus() error: Pending communication transaction in progress");
        } else if (byArray2[2] == -32) {
            System.out.println("NXTCommand.LSGetStatus() error: Specified channel connection not configured or busy");
        } else if (byArray2[2] != 0) {
            System.out.println("NXTCommand.LSGetStatus() Error Number " + byArray2[2]);
        }
        byte[] byArray3 = new byte[]{byArray2[2], byArray2[3]};
        return byArray3;
    }

    public static byte LSWrite(byte by, byte[] byArray, byte by2) {
        byte[] byArray2 = new byte[]{-128, 15, by, (byte)byArray.length, by2};
        byArray2 = NXTCommand.appendBytes(byArray2, byArray);
        return NXTCommand.sendRequest(byArray2);
    }

    public static byte[] LSRead(byte by) {
        byte[] byArray = new byte[]{0, 16, by};
        NXTComm.sendData(byArray);
        byte[] byArray2 = NXTComm.readData();
        byte by2 = byArray2[3];
        byte[] byArray3 = new byte[by2];
        if (byArray2[2] != 0) {
            if (byArray2[2] == -32) {
                System.out.println("NXTCommand.LSRead error: Specified channel connection not configured or busy.");
                return null;
            }
            System.out.println("NXTCommand.LSRead error: " + byArray2[2]);
            return null;
        }
        System.arraycopy(byArray2, 4, byArray3, 0, by2);
        return byArray3;
    }

    private static byte sendRequest(byte[] byArray) {
        byte by = 0;
        if (verifyCommand) {
            byArray[0] = 0;
        }
        NXTComm.sendData(byArray);
        if (verifyCommand) {
            byte[] byArray2 = NXTComm.readData();
            by = byArray2[2];
        }
        return by;
    }

    public static void setVerify(boolean bl) {
        verifyCommand = bl;
    }

    public static boolean isVerify() {
        return verifyCommand;
    }

    public static void close() {
        NXTComm.close();
    }

    static {
        try {
            NXTComm.open();
        }
        catch (Exception exception) {
            System.out.println("Error while connecting NXTCommand() constructor");
            exception.printStackTrace();
        }
    }
}

