/***************************************************************************
 *   Copyright (C) 2008 by Michael Gerhäuser   *
 *   michael.gerhaeuser@gmx.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "main.h"

int welche_funktion = 0;

MY_DATA target(MY_DATA * x) {
    REAL_DATA y[2];

    y[0] = x[0]/SCALE;
    y[1] = x[1]/SCALE;

    MY_DATA z;

//    MY_DATA z = (MY_DATA)((sin(y[0]) + sin(y[1]))*SCALE);
//    MY_DATA z = y[1]*y[1]*y[1]*y[1]*cos(2*y[0]+1.5*PI) + y[0]*y[0]*y[0]*sin(3/PI*y[1]+3);

    if(welche_funktion==1)
        z = (MY_DATA)(((y[0]-50)*(y[0]-50) + (y[1]-50)*(y[1]-50))*SCALE);
    else if(welche_funktion==2)
        z = (MY_DATA)((y[0]-25.001)*(y[0]-75.)*(y[0]-50.)*(y[0]-50.)+(y[1]-25.)*(y[1]-75.)*(y[1]-50.)*(y[1]-50.));
    else
        z = (MY_DATA)((2+y[0]/3*sin((3*M_PI)/105 * y[0]) + y[1]/3*cos((6*M_PI)/105 * y[1]))*SCALE);

    return z;
}

int main() {

    cout << "Welche Funktion soll minimiert werden?" << endl;
    cout << "0:  2+x/3*sin((3*PI)/105 * x) + y/3*cos((6*PI)/105 * y)" << endl;
    cout << "1:  (x-50.)*(x-50.) + (y-50.)*(y-50.)" << endl;
    cout << "2:  (x-25.)*(x-75.)*(x-50.)*(x-50.)+(y-25.)*(y-75.)*(y-50.)*(y-50.)" << endl;
    cout << "3: Abbrechen" << endl;
    cin >> welche_funktion;

    if(! ( (welche_funktion==0) || (welche_funktion==1) || (welche_funktion==2) ) ) {
        cout << "Abbruch durch Benutzer, Beende." << endl;
        return 0;
    }

    int groesse = 200;
    int anzahl_kinder = 100;
    int anzahl_generationen = 40;

    cout << endl << "Groesse der Population? ";
    cin >> groesse;
    cout << "Anzahl der generierten Kinder pro Durchlauf? ";
    cin >> anzahl_kinder;
    cout << "Anzahl der berechneten Generationen? ";
    cin >> anzahl_generationen;

    cout << "Starte Berechnung..." << endl << endl;

    init_operators();

    MY_DATA ** population;
    MY_DATA ** kinder;
    MY_DATA * ziel;
    int * index;

    /* Speicher reservieren fuer die Population und die Kindgeneration */
    population = new MY_DATA*[groesse];
    for(int i=0; i<groesse; i++) {
        population[i] = new MY_DATA[2];
    }

    kinder = new MY_DATA*[anzahl_kinder];
    for(int i=0; i<anzahl_kinder; i++) {
        kinder[i] = new MY_DATA[2];
    }

    ziel = new MY_DATA[groesse+anzahl_kinder];
    index = new int[groesse+anzahl_kinder];

    double * av_fitness = new double[anzahl_generationen];

    /* Initialisieren des Algorithmus */
    erzeuge_adam_und_eva(population, groesse);

    for(int i=0; i<anzahl_generationen; i++) {
        cout << "Erzeuge Generation No. " << (i+1) << "..." << endl;
        erzeuge_naechste_generation(population, groesse, kinder, anzahl_kinder);
        for(int j=0; j<groesse; j++) {
            ziel[j] = target(population[j]);
            index[j] = j;
        }
        for(int j=0; j<anzahl_kinder; j++) {
            ziel[groesse+j] = target(kinder[j]);
            index[groesse+j] = groesse+j;
        }
        selektion(population, groesse, kinder, anzahl_kinder, ziel, index);

//        if((i)%(anzahl_generationen/20) == 0) {
            stringstream str;
            str << "plots/data/generation_" << i;
            population_speichern(population, groesse, str.str());
//        }
        double all = 0.;
        for(int j=0; j<groesse; j++) {
            all += (double)(ziel[j]/SCALE);
        }
        cout << "   Durchschnittliche Fitness: " << (all/groesse) << endl;
        cout << "   Bestes Individuum:          ( " << (population[0][0]/SCALE) << ", " << (population[0][1]/SCALE) << ")" << endl;
        cout << "      Dessen Fitness:         " << (ziel[0]/SCALE) << endl;

        av_fitness[i] = all/groesse;
    }
    stringstream str;
    str << "plots/data/generation_" << anzahl_generationen;
    population_speichern(population, groesse, str.str());

    vektor_speichern(av_fitness, anzahl_generationen, "plots/data/avfitness");

    /* Speicher freigeben */
    for(int i=0; i<anzahl_kinder; i++) {
        delete [] kinder[i];
    }
    delete [] kinder;
    for(int i=0; i<groesse; i++) {
        delete [] population[i];
    }
    delete [] population;

    delete [] ziel;
    delete [] index;

    cin.get();

    return 0;
}
